/******************************************************************************
#ifdef PADN_DOC
 * %Id: mss_bridge_data.h,v 1.1 2010/04/23 02:21:18 akyamada Exp $
#endif
 *
 * FileName		:mss_bridge_data.h
 *
 * Description	:Data definition header for bridge
 *
 *
 * Copyright	:Panasonic Corporation.
 *
 *****************************************************************************/
#ifndef MSS_BRIDGEDATA_H
#define MSS_BRIDGEDATA_H


#define MSS_MAX_FD_NAME 256
#define MSS_ID_MAXNUM   20

typedef struct {
    int cmd;
    int (*handler)(int,unsigned int,void *);
} mss_command_t;

struct mss_void_arg_t{
	int error;
};

/* mssAllocateConnection */
struct mss_alloc_connect_arg_t{
	int error;
	unsigned long input_id;
	unsigned long output_id;
	unsigned long connection_id;
};

/* mssFreeConnection */
struct mss_free_connect_arg_t{
	int error;
	unsigned long connection_id;
};

/* mssQueryConnection */
struct mss_query_connect_arg_t{
	int error;
	unsigned char active;
	unsigned long output_id;
	unsigned char input_type;
	unsigned long input_id[MSS_ID_MAXNUM];
	unsigned char input_num_max;
	unsigned char input_num;
};

/* mssSelect1394Direction */
struct mss_select_direction_arg_t{
	int error;
	unsigned long ioput_id;
};

struct mss_sigpol_arg_t{
  unsigned char clock_pol;
  unsigned char order;
};

struct mss_signalpolarity_arg_t{
  int error;
  unsigned long ioput_id;
  struct mss_sigpol_arg_t sigpol;
};

#endif /* MSS_BRIDGE_DATA_H */
